#ifndef CRITICALSECTION_H
#define CRITICALSECTION_H

#include <windows.h>

class CriticalSection
{
public:
    CriticalSection()
    {
        InitializeCriticalSection(&_cs);
    }
    
    ~CriticalSection()
    {
        DeleteCriticalSection(&_cs);
    }

    void enter()
    {
        EnterCriticalSection(&_cs);
    }

    void leave()
    {
        LeaveCriticalSection(&_cs);
    }
private:
    CRITICAL_SECTION _cs;
};

class CSLock
{
public:
    CSLock(CriticalSection& cs) : _cs(cs)
    {
        _cs.enter();
    }
    ~CSLock()
    {
        _cs.leave();
    }

private:
    CriticalSection& _cs;
};

#endif