#include "CDList.h"

// Konstruktor
CDList::CDList()
{
    m_First = 0;
    m_Last = 0;
}

void CDList::AddNewCD(CD* newCD)
{
    if(m_First == 0 && m_Last == 0)
    {
        // diese Liste ist noch leer
        m_First = newCD;
        m_Last = m_First;
    }
    else
    {
        // diese Liste ist nicht leer.

        // m_Last zeigt auf das letzte
        // Element in der Liste. Diesem
        // wird das neue angehngt
        m_Last->SetNext(newCD);

        // Das neue Element ist nun das
        // letzte also m_Last korrigieren
        m_Last = newCD;
    }
}

CD* CDList::AddNewCD()
{
    CD* newCD = new CD;
    AddNewCD(newCD);
    return newCD;
}

// Destruktor
CDList::~CDList()
{
    // hole das erste element
    CD* actual = m_First;

    // solange actual nicht 0 ist
    while(actual != 0)
    {
        // setze den m_First-Zeiger auf das zweite
        // Element. Das Letzte Element wrde uns
        // hier den Zeiger 0 zurckgeben !
        m_First = actual->GetNext();
        // Lsche das Bisherige erste Element
        delete actual;

        actual = m_First;
    }
}

CD* CDList::GetFirst()
{
    return m_First;
}

CD* CDList::GetLast()
{
    return m_Last;
}




