#include "MyString.h"

// fr strlen und
// strcnpy
#include <string.h>

MyString::MyString()
{
    // wichtig !!
    // Zeiger auf 0 initialisieren
    m_pChars = 0;
}

MyString::~MyString()
{
    // Speicher wieder
    // freigeben !
    delete [] m_pChars;
}

// Konstruktor mit Parametern
MyString::MyString(const char* text)
{
    // Lnge des Textes
    // herausfinden
    int laenge = strlen(text);

    // gengend Speicher allozieren.
    // nicht vergessen  : 
    // das abschliessende 0 braucht
    // auch ein Byte, also +1
    m_pChars = new char[laenge+1];

    // Alle Zeichen vom Text
    // kopieren einschl. der
    // abschliessenden 0 
    strncpy(m_pChars, text, laenge+1);
}

// Kopierkonstruktor
MyString::MyString(const MyString& c)
{
    // Lnge des Textes
    // des anderen Objektes
    // herausfinden
    int laenge = strlen(c.m_pChars);

    // jetzt noch Speicher
    // allozieren und den
    // Text des anderen Objektes
    // kopieren
    m_pChars = new char[laenge+1];
    strncpy(m_pChars, c.m_pChars, laenge+1);
}

// Zuweisungsoperator
MyString& MyString::operator=(const MyString& z)
{
    // Zuweisung an mich selbst ?
    // Also prfen ob this ungleich
    // der Adresse von z ist
    if(this != &z)
    {
        // zuerst alten Speicher
        // freigeben !
        delete [] m_pChars;

        // jetzt genau gleich
        // wie im Kopierkonstruktor
        int laenge = strlen(z.m_pChars);
        m_pChars = new char[laenge+1];
        strncpy(m_pChars, z.m_pChars, laenge+1);
    }

    return *this;
}

// Zuweisungsoperator fr char
void MyString::operator=(const char* text)
{
    // falls vorher bereits
    // Speicher alloziert wurde
    // zum Beispiel im Konstruktor
    // mit Parameter, diesen wieder
    // freigeben !
    delete [] m_pChars;

    // jetzt gleicher Code wie
    // oben im Konstruktor mit Parametern
    int laenge = strlen(text);
    m_pChars = new char[laenge+1];
    strncpy(m_pChars, text, laenge+1);
}


