#include "MyString.h"

// fr strlen und
// strcnpy
#include <string.h>

MyString::MyString()
{
    // wichtig !!
    // Zeiger auf 0 initialisieren
    m_pChars = 0;
}

MyString::~MyString()
{
    // Speicher wieder
    // freigeben !
    delete [] m_pChars;
}

// Konstruktor mit Parametern
MyString::MyString(const char* text)
{
    // Lnge des Textes
    // herausfinden
    int laenge = strlen(text);

    // gengend Speicher allozieren.
    // nicht vergessen  : 
    // das abschliessende 0 braucht
    // auch ein Byte, also +1
    m_pChars = new char[laenge+1];

    // Alle Zeichen vom Text
    // kopieren einschl. der
    // abschliessenden 0 
    strncpy(m_pChars, text, laenge+1);
}

// Zuweisungsoperator
void MyString::operator=(const char* text)
{
    // falls vorher bereits
    // Speicher alloziert wurde
    // zum Beispiel im Konstruktor
    // mit Parameter, diesen wieder
    // freigeben !
    delete [] m_pChars;

    // jetzt gleicher Code wie
    // oben im Konstruktor mit Parametern
    int laenge = strlen(text);
    m_pChars = new char[laenge+1];
    strncpy(m_pChars, text, laenge+1);
}

