#include "MyString.h"
#include <string.h>

MyString::MyString()
{
    init();
}


MyString::MyString(const char* initial)
{
    init();
    strncpy(m_daten, initial, MaxChar-1);
}


void MyString::ausgeben(std::ostream& out) const
{
    out << m_daten;
}

int MyString::holeLaenge() const
{
    int laenge = strlen(m_daten);
    return laenge;
}

void MyString::init()
{
    for(int i = 0; i < MaxChar; ++i)
    {
        m_daten[i] = 0;
    }
}

void MyString::operator +=(const MyString& anderer)
{
    int meineLaenge = holeLaenge();
    int maxLaenge = MaxChar - meineLaenge - 1;
    strncat(m_daten, anderer.m_daten, maxLaenge);
}


bool MyString::operator ==(const MyString& anderer)
{
    bool result = false;
    if(0 == strcmp(m_daten, anderer.m_daten))
    {
        result = true;
    }

    return result;
}

MyString MyString::operator +(const MyString& anderer)
{
    MyString result(m_daten);
    result += anderer;
    return result;
}