// LeftView.cpp : implementation of the CLeftView class
//

#include "stdafx.h"
#include "TreeTest.h"

#include "TreeTestDoc.h"
#include "LeftView.h"
#include "Test.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CLeftView

IMPLEMENT_DYNCREATE(CLeftView, CTreeView)

BEGIN_MESSAGE_MAP(CLeftView, CTreeView)
	//{{AFX_MSG_MAP(CLeftView)
	ON_NOTIFY_REFLECT(TVN_SELCHANGED, OnSelchanged)
	ON_NOTIFY_REFLECT(TVN_ENDLABELEDIT, OnEndlabeledit)
	//}}AFX_MSG_MAP
	// Standard printing commands
	ON_COMMAND(ID_FILE_PRINT, CTreeView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CTreeView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CTreeView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CLeftView construction/destruction

CLeftView::CLeftView()
{
	// TODO: add construction code here
    _imageList.Create(IDB_BITMAP1, 20, 3, RGB(255,255,255));
    for(int i = 0; i < 5; ++i)
    {
        CString text;
        text.Format("Test %d", i);
        _tests[i] = new Test(text);
    }
}

CLeftView::~CLeftView()
{
    _imageList.DeleteImageList();
    for(int i = 0; i < 5; ++i)
    {
        delete _tests[i];
    }
}

BOOL CLeftView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CTreeView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////
// CLeftView drawing

void CLeftView::OnDraw(CDC* pDC)
{
	CTreeTestDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	// TODO: add draw code for native data here
}


/////////////////////////////////////////////////////////////////////////////
// CLeftView printing

BOOL CLeftView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// default preparation
	return DoPreparePrinting(pInfo);
}

void CLeftView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add extra initialization before printing
}

void CLeftView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: add cleanup after printing
}

void CLeftView::OnInitialUpdate()
{
	CTreeView::OnInitialUpdate();

	// TODO: You may populate your TreeView with items by directly accessing
	//  its tree control through a call to GetTreeCtrl().
    CTreeCtrl& treeCtrl = GetTreeCtrl();
    treeCtrl.DeleteAllItems();
    treeCtrl.SetImageList(&_imageList, TVSIL_NORMAL);

    LONG style = GetWindowLong(treeCtrl.m_hWnd, GWL_STYLE);
    style = style | TVS_HASBUTTONS | TVS_LINESATROOT | TVS_HASLINES | TVS_EDITLABELS;
    SetWindowLong(treeCtrl.m_hWnd, GWL_STYLE, style);

    HTREEITEM baum = treeCtrl.InsertItem("Baum", 0, 1, TVI_ROOT, TVI_LAST);
    treeCtrl.SetItemData(baum, (DWORD)_tests[0]);

    treeCtrl.InsertItem("Kind 1", 1, 2, baum, TVI_FIRST);
    treeCtrl.InsertItem("Kind 2", 1, 2, baum, TVI_LAST);

    HTREEITEM liebling = treeCtrl.InsertItem("Liebling", 1, 2, baum, TVI_FIRST);
    treeCtrl.InsertItem("Kindeskind", 2, 0, liebling, TVI_LAST);
}

/////////////////////////////////////////////////////////////////////////////
// CLeftView diagnostics

#ifdef _DEBUG
void CLeftView::AssertValid() const
{
	CTreeView::AssertValid();
}

void CLeftView::Dump(CDumpContext& dc) const
{
	CTreeView::Dump(dc);
}

CTreeTestDoc* CLeftView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CTreeTestDoc)));
	return (CTreeTestDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CLeftView message handlers

void CLeftView::OnSelchanged(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_TREEVIEW* pNMTreeView = (NM_TREEVIEW*)pNMHDR;

    TVITEM newItem = pNMTreeView->itemNew;
    HTREEITEM selected = newItem.hItem;
    CTreeCtrl& treeCtrl = GetTreeCtrl();

    CString text = treeCtrl.GetItemText(selected);
    Test* test = (Test*)treeCtrl.GetItemData(selected);
        
	*pResult = 0;
}

void CLeftView::OnEndlabeledit(NMHDR* pNMHDR, LRESULT* pResult) 
{
	TV_DISPINFO* pTVDispInfo = (TV_DISPINFO*)pNMHDR;

    TVITEM item = pTVDispInfo->item;
    HTREEITEM edited = item.hItem;

    CTreeCtrl& treeCtrl = GetTreeCtrl();

    if(item.pszText)
    {
        treeCtrl.SetItemText(edited, item.pszText);
    }
	
    *pResult = 0;
}
