

#ifndef HTMLDOCUMENT_H
#define HTMLDOCUMENT_H

#include <string>
#include <sstream>

class HtmlDocument
{
public:
    HtmlDocument(const std::string& fileName,
                 const std::string& title);

    void save();
    void saveAs(const std::string& filename);

    template<class T>
    std::stringstream& operator << (const T& data)
    {
        _body << data;
        _saved = false;
        return _body;
    }

    void print();
    void show();

private:
    std::string       _fileName;
    std::string       _title;
    std::stringstream _body;
    bool              _saved;
};

template <const char* tag>
class HtmlTag
{
public:
    template<class T>
    std::stringstream& operator << (const T& data)
    {
        _data << data;
        return _data;
    }

    std::string asString() const
    {
        std::string result;
        result = std::string("<") + 
                 std::string(tag) + 
                 std::string(">") +
                 _data.str() + 
                 std::string("</") + 
                 std::string(tag) + 
                 std::string(">");
        return result;
    }
private:
    std::stringstream _data;
};

extern const char* Heading1String;
extern const char* Heading2String;
extern const char* Heading3String;
typedef HtmlTag<Heading1String> Heading1;
typedef HtmlTag<Heading2String> Heading2;
typedef HtmlTag<Heading3String> Heading3;


#endif