#include "HtmlDocument.h"
#include <fstream>
#include <windows.h>

const char* Heading1String = "H1";
const char* Heading2String = "H2";
const char* Heading3String = "H3";

HtmlDocument::HtmlDocument(const std::string& fileName,
                           const std::string& title)
:_fileName(fileName),
 _title(title),
 _saved(false)
{
}

void HtmlDocument::save()
{
    std::ofstream htmlstream(_fileName.c_str());

    htmlstream << "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">" << std::endl;
    htmlstream << "<html>";
    htmlstream << "<head>";
    htmlstream << "<title>";
    htmlstream << _title;
    htmlstream << "</title>";
    htmlstream << "</head>";
    htmlstream << "<body>";
    htmlstream << _body.str();
    htmlstream << "</body>";
    htmlstream << "</html>";

    _saved = true;
}

void HtmlDocument::saveAs(const std::string& filename)
{
    _fileName = filename;
    save();
}

void HtmlDocument::print()
{
    if(false == _saved)
    {
        save();
    }

    ShellExecute(0, "print", _fileName.c_str(), 0, 0, SW_HIDE);
}

void HtmlDocument::show()
{
    if(false == _saved)
    {
        save();
    }

    ShellExecute(0, "open", _fileName.c_str(), 0, 0, SW_SHOW);
}