#ifndef CONSOLE_H // verhindert mehrmaliges INCLUDE
#define CONSOLE_H

///////////////////////////////////////////////////////////

#include <windows.h>
#include <string>

///////////////////////////////////////////////////////////

typedef unsigned int Color; // definiere einen Datentypen Color
// der einem UINT entspricht
const Color Black = 0x00;
const Color Blue  = 0x01;
const Color Green = 0x02;
const Color Red   = 0x04;
const Color Intensity = 0x08;
const Color White = Blue | Green | Red;

///////////////////////////////////////////////////////////

class Console
{
public:
    Console();	// Konstruktor

    ~Console();	// Destruktor

    void locate(int zeile, int spalte);
    void clear();
    // Die Farben knnen mit dem bitweisen oder-operator | 
    // kombiniert werden
    void setColor(Color textColour,  
        Color backgroundColour);

    // den Titel des Fensters setzen
    void setTitle(const std::string& title);

    // die maximale Grsse des Fensters in
    // Anzahl Zeichen setzen
    void setSize(int width, int height);

private:
    HANDLE          _handle;	// member variable
    unsigned int    _width;
    unsigned int    _height;

};

///////////////////////////////////////////////////////////

#endif