#include "Console.h"

///////////////////////////////////////////////////////////

Console::Console()
{
	_handle = GetStdHandle(STD_OUTPUT_HANDLE);
    
    CONSOLE_SCREEN_BUFFER_INFO csbi = { 0 };
    GetConsoleScreenBufferInfo(_handle, &csbi);
    _width = csbi.dwSize.X;
    _height = csbi.dwSize.Y;
}

///////////////////////////////////////////////////////////

Console::~Console()
{
}

///////////////////////////////////////////////////////////

void Console::locate(int zeile, int spalte)
{
	COORD coord;
	coord.X = spalte;
	coord.Y = zeile;

	BOOL ok = SetConsoleCursorPosition(_handle, coord);
}

///////////////////////////////////////////////////////////

void Console::clear()
{
    for(unsigned int y = 0; y < _height; ++y)
    {
        for(unsigned int x = 0; x < _width; ++x)
        {
            DWORD written = 0;
            BOOL ok = WriteConsole(_handle, 
                                   " ", 
                                   1,
                                   &written,
                                   0);
        }
    }

    locate(0, 0);

    /*
	COORD coord;
	coord.X = 0;
	coord.Y = 0;

	DWORD geschriebeneZeichen;
	
	for(int i=0;i<=80;i++)
	{
		coord.Y=i;

		BOOL ok = FillConsoleOutputCharacter(_handle, 
                                             ' ', 
                                             100, 
                                             coord, 
                                             &geschriebeneZeichen);
	}*/
}

///////////////////////////////////////////////////////////

void Console::setColor(Color textColour, 
                       Color backgroundColour)
{
    WORD attribute = textColour | (backgroundColour * 0x10);
    SetConsoleTextAttribute(_handle, attribute);
}

///////////////////////////////////////////////////////////

void Console::setTitle(const std::string& title)
{
    SetConsoleTitle(title.c_str());
}

///////////////////////////////////////////////////////////

void Console::setSize(int width, int height)
{
    COORD size = { 0 };
    size.X = width;
    size.Y = height;
    
    SMALL_RECT rect = { 0 };
    rect.Left   = 0;
    rect.Top    = 0;
    rect.Right  = width;
    rect.Bottom = height;

    BOOL ok = SetConsoleWindowInfo(_handle, TRUE, &rect);

    ok = SetConsoleScreenBufferSize(_handle, size);

    CONSOLE_SCREEN_BUFFER_INFO csbi = { 0 };
    GetConsoleScreenBufferInfo(_handle, &csbi);
    _width = csbi.dwSize.X;
    _height = csbi.dwSize.Y;
}

///////////////////////////////////////////////////////////
