
#include "notenliste.h"
#include <iostream>
#include "Text.h"

using namespace std;

///////////////////////////////////////////////////////////

Notenliste::Notenliste(const std::string& Fach)
           :m_Fach(Fach), m_AnzahlNoten(0),
            m_flaeche(Breite, Hoehe)
{
    m_flaeche.setzeFarbe(RGB(50,50,50));
    Text derText(50,20);
    derText.setzeText(m_Fach);
    derText.setzeFarbe(RGB(10,200,10));
    m_flaeche.textHinzufuegen(derText);
}

///////////////////////////////////////////////////////////

bool Notenliste::hinzufuegen(const Note& note)
{
    bool hinzufuegenOk = false;

    if(m_AnzahlNoten < MaxNoten)
    {
        m_Noten[m_AnzahlNoten] = note;
        m_AnzahlNoten++;
        hinzufuegenOk = true;

        if(m_AnzahlNoten >= 2)
        {
            neueLinie();
        }
    }

    return hinzufuegenOk;
}

///////////////////////////////////////////////////////////

Note Notenliste::berechneDurchschnitt() const
{
    double summe = 0.0;

    for(long i = 0; i < m_AnzahlNoten; ++i)
    {
        const Note& aktuelleNote = m_Noten[i];
        double notenWert = aktuelleNote.holeNote();
        summe = summe + notenWert;
    }

    double durchschnitt = 0.0;

    if(m_AnzahlNoten > 0)
    {
        durchschnitt = summe / (double)m_AnzahlNoten;
    }

    Note ergebnis(durchschnitt);    // bauen wir noch ein
                                    // Notenobjekt
    
    return ergebnis;
}

///////////////////////////////////////////////////////////

void Notenliste::ausgeben() const
{
    cout << endl;
    cout << "Noten des Faches " << m_Fach << endl << endl;
    for(int i = 0; i < m_AnzahlNoten; ++i)
    {
        m_Noten[i].ausgeben();
    }

    Note durchschnittNote = berechneDurchschnitt();
    cout << "Durchschnitt : " << endl;
    durchschnittNote.gerundetAusgeben(Note::Halbe);
}

///////////////////////////////////////////////////////////

void Notenliste::ausgeben(ostream& out) const
{
    out << endl;
    out << "Noten des Faches " << m_Fach << endl << endl;
    for(int i = 0; i < m_AnzahlNoten; ++i)
    {
        m_Noten[i].ausgeben(out);
    }

    Note durchschnittNote = berechneDurchschnitt();
    out << "Durchschnitt : " << endl;
    durchschnittNote.gerundetAusgeben(Note::Halbe, out);
}

///////////////////////////////////////////////////////////

void Notenliste::neueLinie()
{
    int AnzahlLinien = m_AnzahlNoten-1;

    int xBreite = Breite / AnzahlLinien;

    for(int i = 0; i < AnzahlLinien; ++i)
    {
        int x1 = i * xBreite;
        int x2 = x1 + xBreite;
        Note note1 = m_Noten[i];
        Note note2 = m_Noten[i+1];
        int y1 = berechneY(note1);
        int y2 = berechneY(note2);

        m_linien[i].setzeLinie(x1, y1, x2, y2);
    }
    Linie& neueLinie = m_linien[AnzahlLinien-1];
    neueLinie.setzeFarbe(RGB(200,0,0));
    m_flaeche.linieHinzufuegen(neueLinie);
}

///////////////////////////////////////////////////////////

int Notenliste::berechneY(const Note& note)
{
    double notenWert = note.holeNote();

    int hoeheProNote = Hoehe / 5;

    int notenHoehe = Hoehe - (hoeheProNote * (notenWert-1.0));

    return notenHoehe;
}

///////////////////////////////////////////////////////////

