#include "note.h"
#include <iostream>

using namespace std;

///////////////////////////////////////////////////////////

Note::Note()
     :m_notenWert(1.0) // initialisierung
{
}

///////////////////////////////////////////////////////////

Note::Note(double note)
     :m_notenWert(note)
{
}

///////////////////////////////////////////////////////////

Note::Note(const Note& vorlage)
{
    m_notenWert = vorlage.m_notenWert;
}

///////////////////////////////////////////////////////////

void Note::setzeNote(double note)
{
    m_notenWert = note;
}

///////////////////////////////////////////////////////////

double Note::holeNote() const
{
    return m_notenWert;
}

///////////////////////////////////////////////////////////

double Note::holeGerundeteNote(enum Note::Rundung rundung) const
{
    double rundungsWert = rundung;  // durch geschickte
                                    // Wahl des enums
                                    // knnen wir etwas
                                    // vereinfachen
    double korrektur = 1.0 / rundungsWert / 2.0;

    int hilfswert = (int)((m_notenWert + korrektur) * rundungsWert);

    double gerundeterWert = (double)hilfswert / rundungsWert;

    return gerundeterWert;
}

///////////////////////////////////////////////////////////

void Note::einlesen()
{
    cout << "Note : ";
    cin >> m_notenWert;
}

///////////////////////////////////////////////////////////

void Note::ausgeben() const
{
    cout << "Note : " << m_notenWert << endl;
}

///////////////////////////////////////////////////////////

void Note::gerundetAusgeben(Note::Rundung rundung) const
{
    double gerundeterWert = holeGerundeteNote(rundung);
    cout << "Note : " << gerundeterWert << endl; 
}

///////////////////////////////////////////////////////////

void Note::ausgeben(ostream& out) const
{
    out << "Note : " << m_notenWert << endl;
}

///////////////////////////////////////////////////////////

void Note::gerundetAusgeben(Note::Rundung rundung,
                                           ostream& out) const
{
    double gerundeterWert = holeGerundeteNote(rundung);
    out << "Note : " << gerundeterWert << endl; 
}

///////////////////////////////////////////////////////////
