#ifndef MYSTRING_H
#define MYSTRING_H

#include <iostream>
using std::ostream;

class MyString
{
public:
    MyString();
    MyString(const char* initial);
    // Bei solchen Klassen muss
    // man unbedingt den Kopierkonstruktor
    // definieren!!
    MyString(const MyString& c);
    // Im Destruktor muss noch
    // Speicher freigegeben werden
    ~MyString();

    void ausgeben(std::ostream& out) const;
    int holeLaenge() const;

    void operator += (const MyString& anderer);
    bool operator == (const MyString& anderer);
    MyString operator+(const MyString& anderer);

private:
    // dynamisch verwalteter Speicher!
    char* m_daten;
};


#endif