#include "MyString.h"
#include <string.h>

///////////////////////////////////////////////////////////

MyString::MyString()
         :m_daten(0)
{
}

///////////////////////////////////////////////////////////
// Kopierkonstruktor
MyString::MyString(const MyString& c)
         :m_daten(0)
{
    int anzahl = c.holeLaenge() + 1;
    m_daten = new char[anzahl];
    strcpy(m_daten, c.m_daten);
}

///////////////////////////////////////////////////////////

MyString::MyString(const char* initial)
         :m_daten(0)
{
    // Hole Anzahl Zeichen und
    // addiere Platz fr die 
    // abschliessende null
    int anzahl = strlen(initial) + 1;
    // Speicher holen
    m_daten = new char[anzahl];
    // und Daten kopieren
    strcpy(m_daten, initial);
}

///////////////////////////////////////////////////////////
// Der Destruktor ist jetzt ntig
// da wir Speicher selber verwalten
MyString::~MyString()
{
    delete m_daten;
}

///////////////////////////////////////////////////////////

void MyString::ausgeben(std::ostream& out) const
{
    out << m_daten;
}

///////////////////////////////////////////////////////////

int MyString::holeLaenge() const
{
    int laenge = strlen(m_daten);
    return laenge;
}

///////////////////////////////////////////////////////////

void MyString::operator +=(const MyString& anderer)
{
    // holeLaenge gibt jeweil die Anzahl Zeichen
    // zurck, also noch eins dazu fr die 0
    int neueLaenge = holeLaenge() + anderer.holeLaenge() + 1;
    // neuer Zeiger fr den ganzen String anlegen
    char* neuDaten = new char[neueLaenge];
    // jetzt zuerst eigene Daten einfgen
    strcpy(neuDaten, m_daten);
    // danach die Daten vom anderen
    // MyString hinzufgen
    strcat(neuDaten, anderer.m_daten);
    // jetzt knnen wir unsere alten
    // Daten lschen
    delete m_daten;
    // und m_daten soll jetzt auf den
    // neu erzeugten string zeigen
    m_daten = neuDaten;
}

///////////////////////////////////////////////////////////

bool MyString::operator ==(const MyString& anderer)
{
    bool result = false;
    if(0 == strcmp(m_daten, anderer.m_daten))
    {
        result = true;
    }

    return result;
}

///////////////////////////////////////////////////////////

MyString MyString::operator +(const MyString& anderer)
{
    MyString result(m_daten);
    result += anderer;
    return result;
}

///////////////////////////////////////////////////////////
